"use strict";

var sdsUrl = "http://localhost:8899/";
if(window.location.hostname !== "localhost") sdsUrl = "/";

const ioTypes = [];
const params = [];

const versionWeb = 1.10;
var versionFullc = undefined;

const FORMAT_HA = 1;
const FORMAT_TB = 2;

$(document).ready(function() {
    //odkaz na taby po nacteni stranky - pokud je v URL, vybere se dany tab, jinak se bere prvni
    if(window.location.hash) {
        $('.nav-tabs :button.nav-link[data-bs-target="' + window.location.hash + '"]').tab("show");
    } 
    
    createIOType(3, "Analogové vstupy", function(obj, data) {
        add(data, 311, "PT-1000");
        add(data, 312, "Interní 12V");    
        add(data, 313, "Interní 5V");
        add(data, 314, "AD-IN 1");
        add(data, 315, "AD-IN 2");
        add(data, 316, "AD-IN 3");
        add(data, 317, "AD-IN 4");
        add(data, 318, "AD-IN 5");
    });
    
    createIOType(9, "Analogové vstupy - RAW", function(obj, data) {
        add(data, 431, "PT-1000");
        add(data, 432, "Interní 12V");    
        add(data, 433, "Interní 5V");
        add(data, 434, "AD-IN 1");
        add(data, 435, "AD-IN 2");
        add(data, 436, "AD-IN 3");
        add(data, 437, "AD-IN 4");
        add(data, 438, "AD-IN 5");
    });
    
    createIOType(4, "Optické vstupy", function(obj, data) {
        for(let a = 0; a < 8; a++) {
            add(data, 1000 + a, "OPTO-" +(a+1) +" počítadlo VT");
            add(data, 1032 + a, "OPTO-" +(a+1) +" počítadlo NT");
            add(data, 1064 + a, "OPTO-" +(a+1) +" čas. vzd. mezi impulzy");
            add(data, 151 + a, "OPTO-" +(a+1) +" stav vstupu");
        }
    });
    
    createIOType(8, "Optické vstupy - výpočty", function(obj, data) {
        for(let a = 0; a < 8; a++) {
            add(data, 1000 + a, "OPTO-" +(a+1) +" celkem VT");
            add(data, 1032 + a, "OPTO-" +(a+1) +" celkem NT");
            add(data, 1064 + a, "OPTO-" +(a+1) +" aktuální hodnota");
        }
    });
    
    createIOType(1, "OneWire - A", function(obj, data) {
        for(let a = 0; a < 32; a++) {
            add(data, 2200 + a, "#" +a +" Základní hodnota (teplota)");
            add(data, 2300 + a, "#" +a +" Doplňková hodnota");
        }
    });
    
    createIOType(2, "OneWire - B", function(obj, data) {
        for(let a = 0; a < 32; a++) {
            add(data, 2700 + a, "#" +a +" Základní hodnota (teplota)");
            add(data, 2800 + a, "#" +a +" Doplňková hodnota");
        }
    });
    
    createIOType(6, "Relé", function(obj, data) {
        for(let a = 0; a < 6; a++) {
            add(data, 231 + a, "Relé #" +(a+1));
        }
    });
    
    createIOType(7, "PWM", function(obj, data) {
        add(data, 192, "PWM-1 procento");
        add(data, 187, "PWM-3 procento");
        add(data, 189, "PWM-4 procento");
        
        add(data, 191, "PWM-1,2 frekvence");
        add(data, 186, "PWM-3,4 frekvence");
    });
    
    createIOType(5, "Obecné", function(obj, data) {
        add(data, 12, "IP adresa SDS");
        add(data, 45, "UpTime");
        add(data, 46, "Teplota SoC");
        add(data, 4, "NTP time");
        add(data, 999, "Tarif");
    });
    
    loadConfig();    
    setInterval(loadStates, 2500);
});

//Preklik jakehokoliv tabu - prida se jen hash do URL
$(document).on("shown.bs.tab", ".nav-tabs :button", function (e) {
    let $url = window.location.href.split("#");

    if(typeof $url[0] !== "undefined") {
        history.replaceState(null, null, $url[0] +$(e.target).data("bs-target")); //tato funkce by prekliky mezi zalozkama nemela ukladat do historie prohlizece
    }
});

function loadStates() {
    $.get(sdsUrl + "getsv?s00=V01&s01=V02&s01=V03").done(function(respText) {
        updateOnlineData(respText.split("|"));
    });
}

function loadConfig() {
    $.get(sdsUrl + "shared.txt").done(function(respText) { //getsv?s01=S01
        let obj, type, paramText, paramNum, tmp;
        let ipText, port, period, aktivita;
        let pole = respText.split("|");

        versionFullc = parseInt(findInArray(pole, "V00"))/100.0;
        if(isNaN(versionFullc)) {
            $(".save-button").attr("disabled", "disabled");
            setPageAlert("V zařízení SDS není nahraný požadovaný FULL-C program!");
            return;
        }
        
        if(versionFullc !== versionWeb) {
            $(".save-button").attr("disabled", "disabled");
            setPageAlert("V zařízení SDS je jiná verze FULL-C prograu než verze web stránky!");
            return;
        }
        
        console.log("Web program version: " +versionWeb);
        console.log("FULL-C program version: " +versionFullc);
        
        updateOnlineData(pole);        
        
        let ipNum = parseInt(findInArray(pole, "U49"));
        let format = parseInt(findInArray(pole, "U48"));
        let pp = parseInt(findInArray(pole, "U47"));
        
        type = format & 0xF;
        aktivita = (format >> 4) & 0x1;
        
        if(!isNaN(ipNum)) {
            ipText = ((ipNum >> 24) & 0xFF) +"." +((ipNum >> 16) & 0xFF) + "." +((ipNum >> 8) & 0xFF) + "." +(ipNum & 0xFF);
        } else {
            ipText = "";
        }

        if(!isNaN(pp)) {
            port = (pp >> 16) & 0xFFFF;
            period =  pp & 0xFFFF;
        } else {
            port = 80;
            period = 10;
        }
        
        $("#server-ip").val(ipText);
        $("#server-url").val(findInArray(pole, "T49"));
        $("#server-host").val(findInArray(pole, "T48"));
        $("#access-token").val(findInArray(pole, "T45"));
        $("#server-port").val(port);
        $("#server-period").val(period);
        $("#server-format").val(type);
        $("#server-aktivita").prop("checked", aktivita);
        
        setMask(type);

        for(let a = 0; a < 32; a++) {
            paramText = findInArray(pole, "T" +(50 + a));
            paramNum = parseInt(findInArray(pole, "U" +(50 + a))) >>> 0;
            
            if(paramNum === 0) {
                obj = {
                    text: "",
                    type: 0,
                    value: 0,
                    id: (50 + a),
                    aktivita: false
                };
            }
            else {
                tmp = (paramNum >> 16) & 0xF;
                obj = {
                    text: paramText,
                    type: tmp,
                    value: paramNum & 0xFFFF,
                    id: (50 + a),
                    aktivita: (tmp !== 0)
                };
            }
            
            params.push(obj);   
        }

        params.sort(function(a, b) {
            return a.id > b.id ? 1 : -1;
        });
        
        let $paramTable = $("#param-table");
        let $paramRow = $("#param-table-row");

        for(let a = 0; a < params.length; a++) {
            let $newRow = $paramRow.clone();
            $newRow.removeClass("d-none");
            $newRow.data("paramId", params[a].id);

            $newRow.find(".io-text").val(params[a].text);
            $newRow.find(".io-aktivita").prop("checked", params[a].aktivita);
            
            
            fillData($newRow.find(".io-type"), ioTypes, params[a].type);
            
            ioTypes.find(function(obj) {
                if(obj.value === params[a].type) {
                    fillData($newRow.find(".io-item"), obj.data, params[a].value);
                }
            });
            
            if(params[a].aktivita) {
                $newRow.find(".form-control, .form-select").removeAttr("disabled");
            } else {
                $newRow.find(".form-control, .form-select").attr("disabled", "disabled");
            }

            $paramTable.append($newRow);
        }
    }).fail(function() {
        $(".save-button").attr("disabled", "disabled");
        setPageAlert("Chyba! Nepovedlo se načíst konfiguraci z SDS!");
    });
}

function saveTabServer() {
    let ip, hostname, url, port, format;
    let perioda, cmd, aktivita, count, accessToken;

    port = parseInt($("#server-port").val());
    format = parseInt($("#server-format").val());
    aktivita = $("#server-aktivita").prop("checked") ? 1 : 0;    
    url = $("#server-url").val();
    hostname = $("#server-host").val();
    perioda = parseInt($("#server-period").val());
    accessToken = $("#access-token").val();
    count = 0;
    
    if(isEmpty(hostname)) {
        setFormError("server-host", "Adresa serveru musí být vyplněna!");
        count++;
    } else {
        removeFormError("server-host");
    }
    
    if(format === 0) {
        setFormError("server-format", "Vyberte formát dat!");
        count++;
    } else {
        removeFormError("server-format");
    }
    
    if(isNaN(port) || port <= 0 || port > 65535) {
        setFormError("server-port", "Neplatný port!");
        count++;
    } else {
        removeFormError("server-port");
    }
    
    if(isNaN(perioda) || perioda <= 0 || perioda > 300) {
        setFormError("server-period", "Neplatné hodnota!");
        count++;
    } else {
        removeFormError("server-period");
    }
    
    if(isEmpty(url)) {
        setFormError("server-url", "URL skriptu musí být vyplněna!");
        count++;
    } else {
        removeFormError("server-url");
    }

    if(count !== 0) return;
    
    cmd = "sv?S00=2&U49=0&U48=" +((aktivita & 0x1) << 4 | (format & 0xF)) +"&U47=" +((port & 0xFFFF) << 16 | (perioda & 0xFFFF)) +"&T46=" +toBase64(hostname) +"&T47=" +toBase64(url) +"&T45=" +accessToken;
    //console.log(cmd);
    
    $.get(sdsUrl +cmd).done(function(respText) { 
        setTimeout(refreshPage, 500);
    }).fail(function() {
        setPageAlert("Chyba! Nepovedlo se uložit konfiguraci do SDS!");
    });
}

function saveTabParams() {
    let paramId, $paramRow, item;
    let text, type, value, cmd, aktivita;
    var allValid, rowValid;
    
    cmd = "sv?S00=1";
    allValid = true;
    
    $("#param-table > tbody > tr").each(function() {
        $paramRow = $(this);
        paramId = $paramRow.data("paramId");
        
        text = $paramRow.find(".io-text").val().trim();
        type = parseInt($paramRow.find(".io-type").val());
        value = parseInt($paramRow.find(".io-item").val());
        aktivita = $paramRow.find(".io-aktivita").prop("checked");    

        if(isNaN(type)) type = 0;
        if(isNaN(value)) value = 0;

        //prohledam pole parametru
        params.find(function(obj) {
            if(obj.id === paramId) {
                //mazu parametr - jen dam info
                if(!aktivita) {
                    cmd +=  "&U" +paramId +"=0";
                } 
                else {
                    rowValid = validateRow($paramRow, text, type, value);
                    
                    if(allValid && !rowValid) {
                        allValid = false;
                    }

                    if(rowValid) {
                        item = ((type & 0xF) << 16 | (value & 0xFFFF)) >>> 0;  //((aktivita & 0x1) << 20 |
                        cmd += "&T" +paramId +"=" +text +"&U" +paramId +"=" +item;
                        
                        //console.log(paramId, aktivita, type, text, value, obj.aktivita, obj.type, obj.text, obj.value);  
                    }
                }               
            }
        });
    });

    if(!allValid) return;
    
    $.get(sdsUrl +cmd).done(function(respText) { 
        setTimeout(refreshPage, 500);
    }).fail(function() {
        setPageAlert("Chyba! Nepovedlo se uložit konfiguraci do SDS!");
    });
    
}

function validateRow($row, text, type, value) {
    let count = 0;
    
    if(text.length === 0) {
        setTableError($row, "io-text", "Zadej platný název!");
        count++;
    } else if(!(/^[a-zA-Z0-9_-]+$/).test(text)) {
        setTableError($row, "io-text", "Název obsahuje neplatné znaky!");
        count++;
    } else {
        removeTableError($row, "io-text");
    }
    
    if(type <= 0) {
        setTableError($row, "io-type", "Vyberte platnou hodnotu!");
        count++;
    } else {
        removeTableError($row, "io-type");
    }
    
    if(value <= 0) {
        setTableError($row, "io-item", "Vyberte platnou hodnotu!");
        count++;
    } else {
        removeTableError($row, "io-item");
    }
    
    return count === 0;
}
 
function updateOnlineData(pole) {    
    if(!Array.isArray(pole)) return;
    
    let sendOk = parseInt(findInArray(pole, "V01"));
    let sendErr = parseInt(findInArray(pole, "V02"));
    let httpResp = parseInt(findInArray(pole, "V03"));

    if(!isNaN(sendOk)) {
        $("#odeslano-ok").html(sendOk);
    }

    if(!isNaN(sendErr)) {
        $("#odeslano-chyba").html(sendErr);
    }
    
    if(!isNaN(httpResp)) {
        if(httpResp === 0 || Math.round(httpResp / 100, 0)  === 2) {
            $("#http-resp").addClass("d-none");
        } else {
            $("#http-resp").removeClass("d-none");
            
            if(httpResp === 50000) {
                $("#http-resp").html("Žádné parametry k odeslání!");
            } else if(httpResp > 10000) {
                httpResp = httpResp - 10000;
                
                if(httpResp < 1000) {
                    $("#http-resp").html("DNS err: " +httpResp);
                } else {       
                    $("#http-resp").html("HTTP POST err: " +httpResp);
                }
            } else {
                $("#http-resp").html("HTTP response: " +httpResp);
            }
        }
    }
}

function setMask(type) {
    switch(parseInt(type)) {
        case FORMAT_TB:
        default:
            $("#access-token").attr("disabled", "disabled");
            break;
            
        case FORMAT_HA:
            $("#access-token").removeAttr("disabled");
            break;
    }
}
function findInArray(pole, key) {
    let index = pole.indexOf(key);
    if(index !== -1) {
        return pole[index+1];
    }
    return "";
}

function isEmpty(str) {
    return (!str || str.trim().length === 0 || typeof str === "undefined");
}

function toBase64(text) {
    return btoa(text).replaceAll("+", "-").replaceAll("/", '_').replaceAll("=", ".");
}

function setFormError(name, text) {
    let obj;
    
    $("#" +name).addClass("error");
    obj = $("#err-" +name);
            
    obj.removeClass("d-none");
    obj.html(text);
}

function removeFormError(name) {
    $("#" +name).removeClass("error");
    $("#err-" +name).addClass("d-none");
}

function setTableError($row, name, text) {
    let obj;

    $row.find("." +name).addClass("error");
    obj = $row.find(".err-" +name);
            
    obj.removeClass("d-none");
    obj.html(text);
}

function removeTableError($row, name) {
    $row.find("." +name).removeClass("error");
    $row.find(".err-" +name).addClass("d-none");
}

function setPageAlert(text) {
    let obj = $("#page-alert");
            
    obj.removeClass("d-none");
    obj.find(".alert").html(text);
}

function refreshPage() {
    window.location.reload();
}

//
//$(document).on("click", ".io-item-div", function (e) {   
//    $("#param-table").remove($(this));
//    console.log(this);
//});
$(document).on("change", "#server-format", function (e) {  
    setMask(e.target.value);
});

$(document).on("change", ".io-item-div", function (e) {   
    let $ioType = $(e.target);

    if($ioType.hasClass("io-type")) {
        let $ioItem = $(this).find(".io-item");
        let val = parseInt($ioType.val());
        
        if(val === 0) {
            fillData($ioItem, []);
        } else {
            ioTypes.find(function(obj) {
                if(obj.value === val) {
                    fillData($ioItem, obj.data);
                }
            });
        }
    }
    else if($ioType.hasClass("io-aktivita")) {
        if($ioType.prop("checked")) {
            $(this).find(".form-control, .form-select").removeAttr("disabled");
        } else {
            $(this).find(".form-control, .form-select").attr("disabled", "disabled");
            
            //odstraneni pripadnych validacnich chyb
            $(this).find(".form-control, .form-select").removeClass("error");
            $(this).find("label.error").addClass("d-none");
        }
    }
});







function fillData($select, pole, value) {
    $select.empty();
    $select.append(new Option("Vyberte...", 0));

    let selected = undefined; 
    for(let a = 0; a < pole.length; a++) {
        if(typeof value === "undefined") {
            value = $select.val();
        }

        if(value === pole[a].value) {
            selected = value;
            $select.append(new Option(pole[a].text, pole[a].value));
        } else {
            $select.append(new Option(pole[a].text, pole[a].value));
        } 
    }
    
    if(typeof selected !== "undefined") {
        $select.val(selected).change();
    }
}

function createIOType(value, text, func) {
    let x = {value: value, text: text, data:[]};
    ioTypes.push(x);
    func(x, x.data);
}

function add(pole, value, text) {
    pole.push({value: value, text: text});
}



