#define VERSION 1.1
#define DEBUG 0

/*
    0.90 - 01.04.2023 - Vychozi verze
    0.91 - 12.04.2023 - Oprava dealokace pameti
    1.00 - 18.04.2023 - Opravy drobnych chyb, zruseni zadavani IP adresy  
 *  1.1  - 18.06.2023 - Podpora formatu pro HomeAssistant, přidány 
 */

#define PARAM_UNDEFINED 0x00
#define PARAM_ONEWIRE_A 0x01
#define PARAM_ONEWIRE_B 0x02
#define PARAM_ANALOG_INPUT 0x03
#define PARAM_ANALOG_INPUT_RAW 0x09
#define PARAM_OPTICAL_INPUT 0x04
#define PARAM_OPTICAL_INPUT_CALC 0x08
#define PARAM_SYSTEM 0x05
#define PARAM_RELAY 0x06
#define PARAM_PWM 0x07


#define CONFIG_TYPE_HOMEASSISTANT 0x01
#define CONFIG_TYPE_THINGSBOARD 0x02

#define ACTION_SAVE_PARAMS 0x01
#define ACTION_SAVE_CONFIG 0x02

#define HTTP_STATE_IDLE 0x00
#define HTTP_STATE_WAITDNS 0x01
#define HTTP_STATE_WAITREQUEST 0x02
unsigned char httpState;

unsigned int S00; //doslo k zapisu z webu

unsigned int ipAdresa[4];
unsigned int dnsResolvStart;
unsigned int sendRequestStart;

#define PARAMS_COUNT 32
#define PARAM_NAME_SIZE 16
#define CONFIG_IP_SIZE 4
#define CONFIG_HOST_SIZE 32
#define CONFIG_URL_SIZE 64
#define CONFIG_TOKEN_SIZE 220

unsigned int V00; //verze - nelze menit
unsigned int V01; //pocet vymen - ok
unsigned int V02; //pocet vymen - chyba
unsigned int V03; //last http response

unsigned int U47; //port + perioda
unsigned int U48; //type
unsigned int U49; //ip adresa
char T46[4 * (CONFIG_HOST_SIZE / 3)]; //config host - base64
char T47[4 * (CONFIG_URL_SIZE / 3)]; //config url - base64

char T45[CONFIG_TOKEN_SIZE]; //config url
char T48[CONFIG_HOST_SIZE]; //config host 
char T49[CONFIG_URL_SIZE]; //config url

char T50[PARAM_NAME_SIZE];
char T51[PARAM_NAME_SIZE];
char T52[PARAM_NAME_SIZE];
char T53[PARAM_NAME_SIZE];
char T54[PARAM_NAME_SIZE];
char T55[PARAM_NAME_SIZE];
char T56[PARAM_NAME_SIZE];
char T57[PARAM_NAME_SIZE];
char T58[PARAM_NAME_SIZE];
char T59[PARAM_NAME_SIZE];
char T60[PARAM_NAME_SIZE];
char T61[PARAM_NAME_SIZE];
char T62[PARAM_NAME_SIZE];
char T63[PARAM_NAME_SIZE];
char T64[PARAM_NAME_SIZE];
char T65[PARAM_NAME_SIZE];
char T66[PARAM_NAME_SIZE];
char T67[PARAM_NAME_SIZE];
char T68[PARAM_NAME_SIZE];
char T69[PARAM_NAME_SIZE];
char T70[PARAM_NAME_SIZE];
char T71[PARAM_NAME_SIZE];
char T72[PARAM_NAME_SIZE];
char T73[PARAM_NAME_SIZE];
char T74[PARAM_NAME_SIZE];
char T75[PARAM_NAME_SIZE];
char T76[PARAM_NAME_SIZE];
char T77[PARAM_NAME_SIZE];
char T78[PARAM_NAME_SIZE];
char T79[PARAM_NAME_SIZE];
char T80[PARAM_NAME_SIZE];
char T81[PARAM_NAME_SIZE];

unsigned int U50;
unsigned int U51;
unsigned int U52;
unsigned int U53;
unsigned int U54;
unsigned int U55;
unsigned int U56;
unsigned int U57;
unsigned int U58;
unsigned int U59;
unsigned int U60;
unsigned int U61;
unsigned int U62;
unsigned int U63;
unsigned int U64;
unsigned int U65;
unsigned int U66;
unsigned int U67;
unsigned int U68;
unsigned int U69;
unsigned int U70;
unsigned int U71;
unsigned int U72;
unsigned int U73;
unsigned int U74;
unsigned int U75;
unsigned int U76;
unsigned int U77;
unsigned int U78;
unsigned int U79;
unsigned int U80;
unsigned int U81;

struct Config {
    char aktivita; //0 a 1
    char type; //HA nebp TB
    unsigned char ip[CONFIG_IP_SIZE];
    char host[CONFIG_HOST_SIZE];
    char url[CONFIG_URL_SIZE];
    unsigned int port;
    unsigned int perioda;
    unsigned int lastTime;
    unsigned int crc;
};

struct ConfigAuth {
    char token[CONFIG_TOKEN_SIZE];
    unsigned int crc;
};

struct Param {
    unsigned char type;
    char name[PARAM_NAME_SIZE]; //teplota_obyvak
    unsigned int value;
    unsigned int crc;
};

struct Config config;
struct ConfigAuth configAuth;
struct Param params[PARAMS_COUNT];


//Kontrola zmen pres webove rozhrani

void checkWebChange() {
    int action;

    if (S00 != 0) {
        action = S00;
        S00 = 0;

        if (action == ACTION_SAVE_PARAMS) {
            saveParams();
        } else if (action == ACTION_SAVE_CONFIG) {
            saveConfig();
        }
    }
}

//generovani JSON textu

unsigned int appendJsonParam(char* buffer, struct Param* param) {
    unsigned int pocet, hodnota;
    float koeficient;
    int teplota;

    pocet = sprintf(buffer, "  \"%s\": ", param->name);
    buffer += pocet;

    if (param->type == PARAM_SYSTEM) {
        if (param->value == 12) { //Ip adresa
            hodnota = SDS_get_u32(12);
            pocet += sprintf(buffer, "\"%u.%u.%u.%u\"", hodnota & 0xFF, (hodnota >> 8) & 0xFF, (hodnota >> 16) & 0xFF, (hodnota >> 24) & 0xFF);
        }
        else if (param->value == 46) { //teplota SoC
            pocet += sprintf(buffer, "%i", SDS_get_i32(46));
        }
        else {
            pocet += sprintf(buffer, "%u", SDS_get_u32(param->value));
        }
    }
    else if (param->type == PARAM_RELAY) {
        hodnota = SDS_get_u32(param->value);
        if (hodnota != 0) hodnota = 1;

        pocet += sprintf(buffer, "%u", hodnota);
    }
    else if (param->type == PARAM_ANALOG_INPUT) {
        pocet += sprintf(buffer, "%0.2f", SDS_get_f32(param->value));
    }
    else if (param->type == PARAM_ANALOG_INPUT_RAW) {
        pocet += sprintf(buffer, "%u", SDS_get_u32(param->value));
    }
    else if (param->type == PARAM_ONEWIRE_A || param->type == PARAM_ONEWIRE_B) {
        teplota = SDS_get_i32(param->value);

        if (teplota == 16777216 || teplota > 12500 || teplota < -5500) {
            pocet += sprintf(buffer, "null");
        } else {
            pocet += sprintf(buffer, "%0.2f", (teplota / 100.0));
        }
    }
    else if (param->type == PARAM_OPTICAL_INPUT_CALC) {
        hodnota = SDS_get_u32(param->value);

        if (param->value >= 1000 && param->value <= 1007) {
            koeficient = (float) optoStruct[param->value - 1000].jednotka_ma_impulsu;
            
            pocet += sprintf(buffer, "%0.3f", hodnota / koeficient);
        } 
        else if (param->value >= 1032 && param->value <= 1038) {
            koeficient = (float) optoStruct[param->value - 1032].jednotka_ma_impulsu;
            
            pocet += sprintf(buffer, "%0.3f", hodnota / koeficient);
        } 
        else if (param->value >= 1064 && param->value <= 1071) {
            koeficient = (float)optoStruct[param->value - 1064].jednotka_ma_impulsu;
            
            if (hodnota > 0) {
                pocet += sprintf(buffer, "%0.3f", (3600000.0 / (hodnota * koeficient)));
            } else {
                pocet += sprintf(buffer, "%u", 0);
            }
        }
    }
    else {
        pocet += sprintf(buffer, "%u", SDS_get_u32(param->value));
    }

    return pocet;
}

void textToParam(char* text, unsigned int cislo, unsigned int index) {
    unsigned int index, value, crc;
    unsigned char type;

    type = (cislo >> 16) & 0xF;
    value = cislo & 0xFFFF;

    if (type == 0) {
        params[index].type = 0;
        memset(&params[index].name[0], 0x0, PARAM_NAME_SIZE);
        params[index].value = 0;
        params[index].crc = 0;
    }
    else {
        params[index].type = type;
        snprintf(&params[index].name[0], PARAM_NAME_SIZE, "%s", &text[0]);
        params[index].value = value;
        params[index].crc = 0;

        crc = getCrc32(&params[index], sizeof (struct Param));
        params[index].crc = crc;

        printParam(&params[index]);
    }
}

void sendData() {
    unsigned int validIp;

    if (strlen(config.host) == 0) {
        printf("Empty host\n");
        return;
    }

    validIp = isIpAddress(config.host);
    if (validIp) {
        sendRequest();
    } else {
        dns_resolv(config.host);
        dnsResolvStart = millis();

        httpState = HTTP_STATE_WAITDNS;

        if (DEBUG) {
            printf("DNS resolv start, host=%s\n", config.host);
        }
    }
}

void sendRequest() {
    unsigned int status, index, a, pocet, state;
    char *buffer;

    if (config.type < 1 || config.type > 2) return;
    
    state = 1; //SDS_get_u32(45)
    sendRequestStart = millis();

    if (config.type == CONFIG_TYPE_HOMEASSISTANT && strlen(configAuth.token) > 0) {
        buffer = (char *) malloc(255);
        sprintf(&buffer[0], "Authorization: Bearer %s", configAuth.token);

        http_header_set_user_row(0, &buffer[0]);

        free(buffer);
        buffer = 0;
    }


    buffer = (char *) malloc(4096);
    index = 0;
    pocet = 0;

    index += sprintf(&buffer[index], "{%c", 10); //pocatek formatu JSON

    if (config.type == CONFIG_TYPE_HOMEASSISTANT) {
        index += sprintf(&buffer[index], "\"state\": %u, %c", state, 10);
        index += sprintf(&buffer[index], "\"attributes\": {%c", 10);
    }

    for (a = 0; a < PARAMS_COUNT; a++) {
        if (params[a].type == PARAM_UNDEFINED) continue;
        if (params[a].value == 0) continue;

        if (pocet > 0) {
            index += sprintf(&buffer[index], ",%c", 10);
        }

        index += appendJsonParam(&buffer[index], &params[a]);
        pocet++;
    }

    if (config.type == CONFIG_TYPE_HOMEASSISTANT) {
        index += sprintf(&buffer[index], "%c}", 10); //konec formatu HA - attributes
    }

    index += sprintf(&buffer[index], "%c}", 10); //konec formatu JSON

    if (DEBUG) {
        printf("%s\n", buffer);
    }

    if (pocet > 0) {
        status = http_get_status(0, 0);
        if (status == 1029) { // 1029 = already working, please wait and try later
            http_close();
        }

        http_header_set_content_type("application/json");
        http_post(ipAdresa[0], ipAdresa[1], ipAdresa[2], ipAdresa[3], config.port, config.host, config.url, (void *) 0, 0, buffer);

        httpState = HTTP_STATE_WAITREQUEST;
    } 
    else {
        V03 = 50000;
    }

    free(buffer);
    buffer = 0;
}

void checkSendData() {
    unsigned int status, responceCode;

    if (httpState == HTTP_STATE_WAITDNS) {
        status = dns_resolv_status(&ipAdresa[0], &ipAdresa[1], &ipAdresa[2], &ipAdresa[3]);
        if (status == 512) {
            if ((unsigned int) (millis() - dnsResolvStart) >= 5000) {
                httpState = HTTP_STATE_IDLE;
                http_close();

                V03 = 10000 + 514;

                if (DEBUG) {
                    printf("DNS resolv timeOut!\n");
                }
            }

            return;
        }

        if (status == 513) { //DNS Ok
            if (DEBUG) {
                printf("DNS resolv Ok, ip=%u.%u.%u.%u\n", ipAdresa[0], ipAdresa[1], ipAdresa[2], ipAdresa[3]);
            }

            sendRequest();
        }
        else {
            V03 = 10000 + status;

            httpState = HTTP_STATE_IDLE;

            if (DEBUG) {
                printf("DNS resolv error!\n");
            }
        }
    } else if (httpState == HTTP_STATE_WAITREQUEST) {
        status = http_get_status(&responceCode, 0);
        if (status == 1023) return; //http pozadavek je stale aktivni

        if (status == 1024) {
            V03 = responceCode;
        } else {
            V03 = 10000 + status;
        }

        if (status == 1024 && responceCode/100 == 2) { //http pozadavek dobehnul
            V01++;
        } else {
            V02++;
        }

        if (DEBUG) {
            printf("Request finish, ip=%u.%u.%u.%u, host=%s, port=%u, url=%s, status=%u, response=%u, time=%ums\n", ipAdresa[0], ipAdresa[1], ipAdresa[2], ipAdresa[3], config.port, config.host, config.url, status, responceCode, (millis() - sendRequestStart));
        }

        httpState = HTTP_STATE_IDLE;
    }
}

void saveConfig() {
    unsigned char tmp[264];
    unsigned int start, port, perioda;
    unsigned char type, aktivita;
    int outLen, crc;

    start = millis();

    //kontrola rozsahu zadanych hodnot, pomoci min/max
    port = min(65535, max(1, (U47 >> 16) & 0xFFFF));
    perioda = min(65535, max(10, U47 & 0xFFFF));
    type = min(2, max(1, U48 & 0xF));
    aktivita = U48 >> 4 & 0x1;

    config.ip[0] = (U49 >> 24) & 0xFF;
    config.ip[1] = (U49 >> 16) & 0xFF;
    config.ip[2] = (U49 >> 8) & 0xFF;
    config.ip[3] = U49 & 0xFF;
    config.port = port;
    config.perioda = perioda;
    config.type = type;
    config.aktivita = aktivita;
    config.crc = 0;

    U49 = config.ip[0] << 24 | config.ip[1] << 16 | config.ip[2] << 8 | config.ip[3];
    U48 = (config.aktivita & 0x1) << 4 | (config.type & 0xF);
    U47 = ((config.port & 0xFFFF) << 16) | (config.perioda & 0xFFFF);


    outLen = SDS_FromBase64(&T46[0], &T48[0], strlen(T46), 0x02); //input, output, inputLengt, flags
    memcpy(&config.host, &T48[0], outLen); //destination, source, len
    config.host[outLen] = 0x0;

    outLen = SDS_FromBase64(&T47[0], &T49[0], strlen(T47), 0x02);
    memcpy(&config.url, &T49[0], outLen);
    config.url[outLen] = 0x0;

    crc = getCrc32(&config, sizeof (config));
    config.crc = crc;

    memset(&tmp, 0xFF, 264);
    memcpy(&tmp, &config, sizeof (config)); //destination, source, len
    DF_write_page(10, &tmp);



    outLen = strlen(T45);
    memcpy(&configAuth.token, &T45[0], outLen);
    configAuth.token[outLen] = 0x0;
    configAuth.crc = 0;

    crc = getCrc32(&configAuth, sizeof (configAuth));
    configAuth.crc = crc;

    memset(&tmp, 0xFF, 264);
    memcpy(&tmp, &configAuth, sizeof (configAuth)); //destination, source, len
    DF_write_page(9, &tmp);

    printConfig(&config);
    printConfigAuth(&configAuth);

    //vynulovani pocitadel
    V01 = 0;
    V02 = 0;
    V03 = 0;

    if (DEBUG) {
        printf("Save config finished, time=%ums\n", millis() - start);
    }
}

void saveParams() {
    unsigned char pageData[264];
    char dataText[PARAM_NAME_SIZE];
    unsigned int a, b, index, dataCislo, start;

    start = millis();

    //4100..4199| u32     |  GET |  Shared Variables: U00 through U99 - read
    //4100..4199| u32     |  SET |  Shared Variables: U00 through U99 - write/

    //projdu sdilene promenne
    for (a = 0; a < PARAMS_COUNT; a++) {
        SDS_get_a(4350 + a, &dataText, PARAM_NAME_SIZE);
        dataCislo = SDS_get_u32(4150 + a);

        textToParam(&dataText, dataCislo, a);
    }

    for (a = 0; a < 8; a++) {
        for (b = 0; b < 4; b++) {
            index = a * 4 + b; //0 - 32

            memcpy(&pageData[b * 66], &params[index], sizeof (struct Param)); //destination, source, len
        }
        DF_write_page(11 + a, &pageData);
    }

    if (DEBUG) {
        printf("Save params complete, time=%ums\n", (millis() - start));
    }
}

void loadConfig() {
    unsigned char pageData[264];
    unsigned int a, b, crc, crcOld, start, index, conf;

    start = millis();

    //printf("Config size=%u bytes, auth=%u bytes\n", sizeof (struct Config), sizeof (struct ConfigAuth));
    //printf("Param size=%u bytes\n", sizeof (struct Param));
    //printf("Param[] size=%u\n", PARAMS_COUNT);

    DF_read_page(9, &pageData);
    memcpy(&configAuth, &pageData, sizeof (struct ConfigAuth)); //destination, source, len
    crcOld = configAuth.crc;
    configAuth.crc = 0;

    crc = getCrc32(&configAuth, sizeof (struct ConfigAuth));
    if (crc != crcOld) {
        printf("No valid security config found! crc1=%u, crc2=%u\n", crc, crcOld);
        memset(&configAuth, 0x0, sizeof (struct ConfigAuth));
    }



    DF_read_page(10, &pageData);
    memcpy(&config, &pageData, sizeof (struct Config)); //destination, source, len
    crcOld = config.crc;
    config.crc = 0;

    crc = getCrc32(&config, sizeof (struct Config));
    if (crc != crcOld) { //neplatna konfigurace (nesouhlasi CRC), resetuju konfiguraci
        printf("No valid config found, use default! crc1=%u, crc2=%u\n", crc, crcOld);
        memset(&config, 0x0, sizeof (struct Config));

        config.perioda = 10;
        config.port = 80;
        sprintf(&config.host[0], "%s", "127.0.0.1");
        config.type = 2; //post + json
        config.aktivita = 0;
    }

    printConfig(&config);
    printConfigAuth(&configAuth);

    memcpy(&T45[0], &configAuth.token, CONFIG_TOKEN_SIZE); //destination, source, len
    memcpy(&T48[0], &config.host, CONFIG_HOST_SIZE); //destination, source, len
    memcpy(&T49[0], &config.url, CONFIG_URL_SIZE); //destination, source, len
    U49 = config.ip[0] << 24 | config.ip[1] << 16 | config.ip[2] << 8 | config.ip[3];
    U48 = (config.aktivita & 0x1) << 4 | (config.type & 0xF);
    U47 = ((config.port & 0xFFFF) << 16) | (config.perioda & 0xFFFF);
    config.lastTime = 0;

    //nacteni 32 parametru z DF do pameti
    for (a = 0; a < 8; a++) {
        DF_read_page(11 + a, &pageData);

        for (b = 0; b < 4; b++) {
            index = a * 4 + b; //0 - 32
            loadParam(&params[index], &pageData[b * 66]);

            if (params[index].type != PARAM_UNDEFINED) {
                conf = ((params[index].type & 0xF) << 16) | (params[index].value & 0xFFFF);

                SDS_set_a(4350 + index, &params[index].name[0], PARAM_NAME_SIZE); //nastaveni do sdilenych promennych
                SDS_set_u32(4150 + index, conf);
            } else {
                SDS_set_a(4350 + index, 0, 1);
                SDS_set_u32(4150 + index, 0);
            }
        }
    }

    if (DEBUG) {
        printf("Load config done, time=%ums\n", (millis() - start));
    }
}

void loadParam(struct Param *param, unsigned char *pageData) {
    int crcOld, crc;

    memcpy(param, pageData, sizeof (struct Param)); //destination, source, len

    crcOld = param->crc;
    param->crc = 0;

    crc = getCrc32(param, sizeof (struct Param));
    if (crc != crcOld) {
        param->type = PARAM_UNDEFINED;
    } else {
        param->crc = crcOld;
        printParam(param);
    }
}

unsigned int isIpAddress(char *data) {
    unsigned int a, pocet, length;
    unsigned int ip[4];

    pocet = sscanf(data, "%u.%u.%u.%u%n", &ip[0], &ip[1], &ip[2], &ip[3], &length);
    if (pocet != 4 || length != strlen(data)) {
        return 0;
    }

    for (a = 0; a < 4; a++) {
        if (ip[a] < 0 || ip[a] > 255) return 0;
    }

    for (a = 0; a < 4; a++) {
        ipAdresa[a] = ip[a];
    }

    //printf("data: %s, len=%u, poc=%u, ip:%u.%u.%u.%u, xlen=%u \n", data, length, pocet, ip[0], ip[1], ip[2], ip[3], strlen(data));

    return 1;
}

void printParam(struct Param* param) {
    if (!DEBUG) return;

    printf("Param: type=%u, name=%s, value=%u, crc=%u\n", param->type, param->name, param->value, param->crc);
}

void printConfig(struct Config* config) {
    if (!DEBUG) return;

    printf("Config: ak=%i, typ=%i, ip=%i.%i.%i.%i, p=%i, host=%s, url=%s, period=%i, crc=%u\n", config->aktivita, config->type,
            config->ip[0], config->ip[1], config->ip[2], config->ip[3], config->port, config->host, config->url, config->perioda, config->crc);
}

void printConfigAuth(struct ConfigAuth* configAuth) {
    if (!DEBUG) return;

    printf("ConfigAuth: %s, crc=%u\n", configAuth->token, configAuth->crc);
}

unsigned int getCrc32(void *ptr, int length) {
    unsigned int crc;
    unsigned char *buffer;

    while (length % 4 != 0) length++;

    buffer = (unsigned char *) malloc(length);

    memset(buffer, 0xFF, length);
    memcpy(buffer, ptr, length); //destination, source, len

    crc = SDS_crypto(0x40, (void *) 0, buffer, length);

    free(buffer);
    buffer = 0;

    return crc;
}

unsigned int millis() {
    return SDS_get_u32(45);
}

int max(int a, int b) {
    if (a > b) return a;
    else return b;
}

int min(int a, int b) {
    if (a < b) return a;
    else return b;
}

void init() {
    wait(1000); //pockam aspon sekundu na najeti 1W, nacteni ntp.. atd..

    httpState = HTTP_STATE_IDLE;
    V00 = VERSION * 100;
    V01 = 0;
    V02 = 0;

    //Nacteni konfigurace opto vstupu
    for (int a = 0; a < 8; a++) {
        SDS_get_a(1500 + a, &optoStruct[a], sizeof (struct OptoStruct));
    }

    loadConfig();
}

void loop() {
    checkWebChange();
    checkSendData();

    if (httpState == HTTP_STATE_IDLE && config.aktivita == 1 && ((unsigned int) (millis() - config.lastTime) >= config.perioda * 1000)) {
        config.lastTime = millis();

        sendData();
    }
}

void main(void) {
    init();

    printf("Starting program, version: %.2f\n", VERSION);

    while (1) {
        loop();
    }
}

struct OptoStruct {
    // WEB-ADMIN CONFIG:
    unsigned long jednotka_ma_impulsu; // kolik impulsu na jednotku (vzdy cele cislo)

    // WEB-ADMIN CONFIG:
    unsigned long cena_za_jednotku_T0; // kolik CZK je za jednotku (pseudofloat, x*100 -> dve desetinna mista)
    unsigned long cena_za_jednotku_T1; // kolik CZK je za jednotku (pseudofloat, x*100 -> dve desetinna mista)

    // WEB-ADMIN CONFIG:
    char jednotka[32 + 1 + 3]; // popisek jednotky se vztahem k casu (napr. kWh - akumulovana energie)

    // WEB-ADMIN CONFIG:
    char penize_jednotka[32 + 1 + 3]; // popisek meny (CZK)

    // WEB-ADMIN CONFIG:
    char jednotka_vykon[32 + 1 + 3]; // popisek jednotky bez vztahu k casu (vykon kW, prutok l/h, . . . )

    // WEB-ADMIN CONFIG:
    char nazev_vykon[32 + 1 + 3]; // popisek nazvu cinnosti

    // WEB-ADMIN CONFIG:
    char nazev_merice[32 + 1 + 3]; // nazev merice energie (nazev vstupu)

    // WEB-ADMIN CONFIG:
    unsigned char je_to_S0_vstup; // je to pouzito?  0 == ne

    // WEB-ADMIN CONFIG:
    unsigned char pouzivam_tarifni_rozliseni; // ==0 : jedno pocitadlo T0, nebo != 0 : dve samostatne T0 a T1

    // nepouzito, ale reservovano
    unsigned char reserved_and_align[2];
    unsigned char reserved_zeros[32 + 1 + 3];


    // WEB-ADMIN CONFIG:
    unsigned long prevodovy_pomer_mtd; // normovany prevodovy pomer x, kde jde o 1:x

    // WEB-ADMIN CONFIG:
    unsigned long minimalni_delka_impulsu; // miliseconds, default == 4

    // WEB-ADMIN CONFIG:
    unsigned short delka_zacatecniho_zakmitu; // v msec (pridano 26.1.2021)

    // WEB-ADMIN CONFIG:
    unsigned short delka_dokmitu; // v msec (pridano 26.1.2021)
};

struct OptoStruct optoStruct[8];