"use strict";

var chartObj1;
var chartObj2;

$(document).ready(function() {
    createChart1();
    createChart2();
    naplnDny();
    
    dataOnline();
    dataChart2();
    
    setInterval(dataOnline, 5000);
});

            
function naplnDny() {
    let objSelect = $("#csv-file");
    
    for(let x = 0; x < 7; x++) {
        let date = new Date();
        date.setTime(date.getTime() - (x * 86400000));

        let value = (date.getFullYear() +"-" +("0" + (date.getMonth()+1)).slice(-2) +"-" +("0" + date.getDate()).slice(-2)) +".csv";
        let text = ("0" + date.getDate()).slice(-2) +"." +("0" + (date.getMonth()+1)).slice(-2) +"." +date.getFullYear();
        
        objSelect.append($("<option>", {
            value: value,
            text : text
        }));
    }
}



function loadArrayValues(respText, attr, updateHtml) {
    let index1, index2, index;
    let pole, key, value;
    let data = [];

    attr += "|";
    index1 = respText.indexOf(attr);
    if(index1 === -1) return data;

    index2 = respText.indexOf("|", index1 + attr.length);
    if(index2 === -1) return data;

    pole = respText.substring(index1 + attr.length, index2).split("&");

    for(let i = 0; i < pole.length; i++) {
        index = pole[i].indexOf("=");
        if(index === -1) continue;
        
        key = pole[i].substring(0, index);
        value = pole[i].substring(index + 1);
        
        data.push({key: key, value: value});
        
        if(updateHtml) {
            let obj = $("#" +key);
            
            if(obj.length > 0) {
                obj.html(value);
            }  
        }
    }
    
    return data;
}        

function findArrayValue(pole, key) {
    let obj = pole.find(x => x.key === key);
    if(typeof(obj) !== "undefined") return obj.value;
    return undefined;
}
      
function dataOnline() {
    $.get("/shared.txt").done(function(respText) { //getsv?s01=S01
        $("#main-alert").addClass("d-none");

        let pole = loadArrayValues(respText, "S01", true); //Nacteni on-line dat elektromeru
        
        let sdStatus = findArrayValue(pole, "sdc");
        let sdSize = findArrayValue(pole, "sdv");        
        let stateTime = findArrayValue(pole, "dtb");

        changeStateSDCard(sdStatus, sdSize);
        changeStateOnline(stateTime);
        
        loadArrayValues(respText, "S02", true); //Nacteni pocitadel elektromeru
        
        pole = loadArrayValues(respText, "S03", false); //Nacteni on-line grafu
        
        let timeStamp, date;
        let labels = [];
        let data = [];
        
        for(let i = 0; i < pole.length; i++) {
            timeStamp = parseInt(pole[i].key, 16) + 1670000000; 
            date = new Date(timeStamp*1000);
            
            labels.push(("0" + date.getHours()).slice(-2) +":" +("0" + date.getMinutes()).slice(-2) +":" +("0" + date.getSeconds()).slice(-2));
            data.push(parseInt(pole[i].value));   
        }
        
        chartObj1.data.datasets[0].data = data;
        chartObj1.data.labels = labels;
        chartObj1.update("none");
    })
    .fail(function(xhr) {
        $("#main-alert").removeClass("d-none");
        $("#main-alert-text").html("Chyba komunikace s SDS! (" +xhr.status +" - " +xhr.statusText +")");
    });
}

function dataChart2() {
    let csvFile = $("#csv-file").val();
    
    $.get("/web/data/" +csvFile).done(function(respText) { //getsv?s02=S02
        let labels = [];
        let tips = [];
        let data1 = [];
        let data2 = [];
        let data3 = [];
        
        let last1, last2, last3, lastTime, spotreba;
        let rowData, rowFirst, rowLast;
        
        let lines = respText.split("\r\n");
        for (let x = 0; x < lines.length; x++) {
            rowData = lines[x].split(";");
            if(rowData.length < 4) {
                continue;
            }
            
            if(x === 0) {
                lastTime = rowData[0].substring(11, 16);
                last1 = parseFloat(rowData[1]);
                last2 = parseFloat(rowData[2]); 
                last3 = parseFloat(rowData[3]); 
                continue;
            }
            
            data1.push((parseFloat(rowData[1]) - last1).toFixed(3));
            data2.push((parseFloat(rowData[2]) - last2).toFixed(3));
            data3.push((parseFloat(rowData[3]) - last3).toFixed(3));
            labels.push(rowData[0].substring(11, 16));    
            tips.push(lastTime +" - " +rowData[0].substring(11, 16));    
            
            lastTime = rowData[0].substring(11, 16);
            last1 = parseFloat(rowData[1]);
            last2 = parseFloat(rowData[2]); 
            last3 = parseFloat(rowData[3]); 
        }
        
        rowFirst = lines[0].split(";");
        rowLast = lines[lines.length - 2].split(";");
        
        spotreba = (parseFloat(rowLast[1]) - parseFloat(rowFirst[1])).toFixed(3);
        $("#denni-spotreba").html(spotreba);
        $("#chart-alert").addClass("d-none");
        
        chartObj2.data.datasets[0].data = data1; 
        chartObj2.data.labels = labels;
        chartObj2.data.datasets[0].tips = tips;
        chartObj2.update("none");
    })
    .fail(function(xhr) {
        $("#denni-spotreba").html("N/A");

        chartObj2.data.datasets[0].data = []; 
        chartObj2.data.labels = [];
        chartObj2.data.datasets[0].tips = [];
        chartObj2.update("none");
        
        $("#chart-alert").removeClass("d-none");
        $("#chart-alert-text").html("Nenalezen CSV soubor (" +csvFile +") pro vybraný den!");
    });
}





function createChart1() {
    let config = {
        type: "line",
        
        data: {
            labels: [],
            datasets: [{
                label: "Celkem výkon [W]",
                data: [],
                borderWidth: 1,
                borderColor: "rgb(255, 28, 72)",
                backgroundColor: "rgba(255, 28, 72, 0.5)"
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            
            interaction: {
                intersect: false,
                mode: "index"
            },
            
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    };
      
    chartObj1 = new Chart($("#chart1")[0], config);
}



function createChart2() {  
    let config = {
        type: "line",
        
        data: {
            labels: [],
            datasets: [{
                label: "Spotřeba [kWh]",
                data: [],
                tips: [],
                borderWidth: 1,
                borderColor: "rgb(255, 28, 72)",
                backgroundColor: "rgba(255, 28, 72, 0.5)"
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            
            interaction: {
                intersect: false,
                mode: "index"
            },
    
            scales: {
                y: {
                    beginAtZero: true
                }
            },
            
            plugins: {
                tooltip: {
                    callbacks: {
                        title: function(context) {
                            return context[0].dataset.tips[context[0].dataIndex];
                        }
                    }
                }
            }
        }
    };
      
    chartObj2 = new Chart($("#chart2")[0], config);
}





function changeStateSDCard(sdStatus, sdSize) {
    let sd = $("#sd-card");
    
    if(typeof(sdStatus) === "undefined") {
        sd.html('<span class="badge bg-danger">SD N/A</span>');
    } else if(parseInt(sdStatus) === 1) {
        sd.html('<span class="badge bg-success">SD OK (' +(sdSize/1024) +'MB)</span>');
    } else {
        sd.html('<span class="badge bg-danger">SD Nepřipojena</span>');
    }
}

function changeStateOnline(stateTime) {
    let state = $("#state");
    
    if(typeof(stateTime) === "undefined") {
        state.html('<span class="badge bg-danger">RS485 N/A</span>');
        $(".js-value").html("N/A");
    } else if(parseInt(stateTime) < 20) {
        state.html('<span class="badge bg-success">RS485 On-line</span>');
    } else {
        state.html('<span class="badge bg-danger">RS485 Off-line</span>');
    }
}


